//
//  MCQueryRegistry.h
//  MCApplication
//
//  Created by Michael Clark on 17/08/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCQueryCriteria;

@interface MCQueryRegistry : NSObject {
	@private
	
	NSMutableDictionary*     _criteriaRegistry;
	NSMutableDictionary*     _criteriaSubsetRegistry;
	NSMutableDictionary*     _operatorRegistry;
//	NSMutableDictionary*     _processors;
//	NSMutableDictionary*     _criteriaProcessors;
}

+ (MCQueryRegistry*)defaultInstance;

- (void)registerCriteriaConfig: (NSDictionary*)criteria forEntityName: (NSString*)entityName;
- (NSArray*)criteriasForEntityName: (NSString*)entityName criteriaSubsetIdentifier:(NSString *)subsetIdent;
- (MCQueryCriteria*)criteriaForIdentifier: (NSString*)identifier;

- (MCQueryCriteria*)_legacyCriteriaForIdentifier: (NSString*)identifier;

- (void)registerCriterias: (NSArray*)criterias;
- (void)registerCriteriaSubsets: (NSArray*)subsets forEntityNamed: (NSString*)entityName;

- (void)registerCriteriaConfigs: (NSArray*)criteriaConfigs;


// The operator registry gets automatically populated with the base set of operators
// Bundles/Apps could define custom operators to do something special, as long as their sqlProcessors
//  understand the new operator.
- (void)registerQueryOperatorsFromConfigFile: (NSString*)path;
- (void)registerOperator: (NSDictionary*)anOperator;
- (NSArray*)operatorsForType: (NSString*)aType;
- (NSDictionary*)operatorForIdentifier: (NSString*)identifier;

- (void)registerProcessor: (id)aProcessor;
//- (id)processorNamed: (NSString*)name;
//
//- (id)criteriaProcessorNamed: (NSString*)name;



////// ACCESSORS //////
- (NSMutableDictionary *)criteriaRegistry;
- (void)setCriteriaRegistry:(NSMutableDictionary *)aCriteriaRegistry;

- (NSMutableDictionary *)criteriaSubsetRegistry;
- (void)setCriteriaSubsetRegistry:(NSMutableDictionary *)aCriteriaSubsetRegistry;

- (NSMutableDictionary *)operatorRegistry;
- (void)setOperatorRegistry:(NSMutableDictionary *)anOperatorRegistry;

//- (NSMutableDictionary *)processors;
//- (void)setProcessors:(NSMutableDictionary *)aProcessors;
//
//- (NSMutableDictionary *)criteriaProcessors;
//- (void)setCriteriaProcessors:(NSMutableDictionary *)aCriteriaProcessors;

@end
